<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="download.png">
    <meta name="author" content="Ebrahim Shafiei (EbraSha)">
    <meta content="Prof.Shafiei@Gmail.com" name="Email"/>
    <title>Abdal PHP Remote Downloader ver 5.4</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <style>
        .progress {
            height: 30px;
        }

        .progress-bar {
            font-size: 1.1em;
        }

        .form-inline-custom {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .form-inline-custom .form-group {
            flex: 1;
            margin-right: 10px;
        }

        .form-inline-custom button {
            margin-left: 10px;
        }

        .container {
            max-width: 800px;
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <div class="row">
        <div class="col-md-12 text-center">
            <img class="mb-2"
                 src="data:image/png;base64,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"
                 height="75" width="75" alt="Downloader">
            <h1 title="version 5.4">Abdal PHP Remote Downloader</h1>
            <form id="downloadForm" class="form-inline-custom">
                <div class="form-group mb-2">
                    <label for="fileUrl" class="sr-only">File URL</label>
                    <input type="url" class="form-control" id="fileUrl" name="fileUrl" placeholder="Enter file URL"
                           required>
                </div>
                <button type="submit" class="btn btn-primary mb-2">Download</button>
            </form>
            <div class="progress mt-3">
                <div id="progress-bar" class="progress-bar progress-bar-striped progress-bar-animated bg-success"
                     role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">0%
                </div>
            </div>
            <div id="progress-text" class="mt-3 badge bg-warning  text-white"></div>

            <div class="footer mt-2">
                <div>Programmer: Ebrahim Shafiei (EbraSha)</div>
                <div>Email : Prof.Shafiei@Gmail.com</div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
<script>
    $(document).ready(function () {
        $('#downloadForm').on('submit', function (e) {
            e.preventDefault();
            var fileUrl = $('#fileUrl').val();
            $('#progress-bar').css('width', '0%').attr('aria-valuenow', 0).text('0%');
            $('#progress-text').text('');
            downloadFile(fileUrl, 0, 0); // Initialize with start = 0 and totalSize = 0
        });

        function downloadFile(url, start, totalSize) {
            $.ajax({
                url: 'download.php',
                type: 'POST',
                data: {fileUrl: url, start: start, totalSize: totalSize},
                dataType: 'json',
                success: function (response) {
                    console.log(response); // Log the response for debugging
                    if (response.error) {
                        $('#progress-text').html('Error: ' + response.error);
                    } else {
                        totalSize = response.totalSize || totalSize;
                        var downloaded = response.downloaded;
                        var progress = (downloaded / totalSize) * 100;
                        $('#progress-bar').css('width', progress + '%').attr('aria-valuenow', progress).text(progress.toFixed(2) + '%');

                        if (response.continue) {
                            $('#progress-text').html('Downloaded ' + formatBytes(downloaded) + ' of ' + formatBytes(totalSize) + ' so far...');
                            downloadFile(url, downloaded, totalSize);
                        } else {
                            $('#progress-text').html('Download complete: <a href="' + response.file + '">Download File</a>');
                        }
                    }
                },
                error: function (xhr, status, error) {
                    $('#progress-text').html('Error: ' + error);
                    console.error(xhr.responseText); // Log the response text for debugging
                }
            });
        }

        function formatBytes(bytes, decimals = 2) {
            if (bytes === 0) return '0 Bytes';
            const k = 1024;
            const dm = decimals < 0 ? 0 : decimals;
            const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
        }
    });
</script>
</body>
</html>
